# Redo's New Duplicator Edit
A fork of the original New Duplicator by Zeblote, presently maintained and with many improvements.

## New Features
- Added the `/ownership` or `/o` command, which plants each brick in the current selection with its original ownership. Use in plant mode after copying/cutting.  
`/savedup` now saves ownership, and `/ownership` can be used while holding a loaded duplication to load it.  
(Loading ownership only works if the duplication was saved with this version, as the original newdup does not save ownership)
- Holding ctrl while making an initial stack selection selects all adjacent bricks of the same color, ignoring diagonals.  
With limited mode off, all adjacent bricks will be selected regardless of color.
- The `/alldups` list is nicely formatted, sorted by date, and shows who saved each item.
- Support for Brick_LuaLogic  
Supercut can be used on wire bricks.  
`/FillBrick LogicWire` or `/fbw` can be used to fill with wire bricks.  
Initial-multi-box-selecting a ROM sets the box to its data volume.
- Initial multi-box-selecting a brick with a zone sets the box to its zone.  
Hitting plant with this box updates the first Event_SetZoneBox event if present.

## Tweaks
- Made the "Create Sym Table on Start" pref default to true.
- Changed a lot of chat messages to be center-prints instead.
- Multi-selecting in box mode now only selects a single stud if ctrl was/is held for the first selection, otherwise it selects the entire brick.

## Fixes
- Fixed "Nonexistent undo state" message when undoing a plant that has been supercut.
- Fixed preventing unequipping any tool for 1.5s after using `/duplicator`
- Removed useless files from the add-on root directory
- Removed the annoying messages about mismatched newdup versions when joining a server.
- Removed the worm known as Support_Updater.
- Probably some more stuff I forgot about.
