
function buildprint_getFieldOr(%val, %field, %or) {
	%v = getField(%val, %field);
	if(%v $= "") return %or;
	return %v;
}

function buildprint_findprints() {
	$bp_letters = "";
	$bp_fallback1 = "";
	$bp_fallback2 = "";
	$bp_fallback3 = "";
	$bp_prints = "";
	
	%tex_chars["0"] = "0";
	%tex_chars["1"] = "1";
	%tex_chars["2"] = "2";
	%tex_chars["3"] = "3";
	%tex_chars["4"] = "4";
	%tex_chars["5"] = "5";
	%tex_chars["6"] = "6";
	%tex_chars["7"] = "7";
	%tex_chars["8"] = "8";
	%tex_chars["9"] = "9";
	%tex_chars["A"] = "A	a";
	%tex_chars["B"] = "B	b";
	%tex_chars["C"] = "C	c";
	%tex_chars["D"] = "D	d";
	%tex_chars["E"] = "E	e";
	%tex_chars["F"] = "F	f";
	%tex_chars["G"] = "G	g";
	%tex_chars["H"] = "H	h";
	%tex_chars["I"] = "I	i";
	%tex_chars["J"] = "J	j";
	%tex_chars["K"] = "K	k";
	%tex_chars["L"] = "L	l";
	%tex_chars["M"] = "M	m";
	%tex_chars["N"] = "N	n";
	%tex_chars["O"] = "O	o";
	%tex_chars["P"] = "P	p";
	%tex_chars["Q"] = "Q	q";
	%tex_chars["R"] = "R	r";
	%tex_chars["S"] = "S	s";
	%tex_chars["T"] = "T	t";
	%tex_chars["U"] = "U	u";
	%tex_chars["V"] = "V	v";
	%tex_chars["W"] = "W	w";
	%tex_chars["X"] = "X	x";
	%tex_chars["Y"] = "Y	y";
	%tex_chars["Z"] = "Z	z";
	%tex_chars["-and"         ] = "&";
	%tex_chars["-apostrophe"  ] = "\'	\"";
	%tex_chars["-asterisk"    ] = "*";
	%tex_chars["-at"          ] = "@";
	%tex_chars["-bang"        ] = "!	/	\\	|";
	%tex_chars["-caret"       ] = "^";
	%tex_chars["-dollar"      ] = "$";
	%tex_chars["-equals"      ] = "=	;	:";
	%tex_chars["-greater_than"] = ">	)	]	}";
	%tex_chars["-less_than"   ] = "<	(	[	{";
	%tex_chars["-minus"       ] = "-	_";
	%tex_chars["-percent"     ] = "%";
	%tex_chars["-period"      ] = ".	,";
	%tex_chars["-plus"        ] = "+";
	%tex_chars["-pound"       ] = "#";
	%tex_chars["-qmark"       ] = "?";
	%tex_chars["-space"       ] = " ";
	%tex_chars["-apostrophe2"       ] = "\"";
	%tex_chars["-colon"             ] = ":";
	%tex_chars["-comma"             ] = ",";
	%tex_chars["-curlybracketleft"  ] = "}";
	%tex_chars["-curlybracketright" ] = "{";
	//%tex_chars["-currencysign"      ] = "";
	//%tex_chars["-euro"              ] = "";
	//%tex_chars["-onehalf"           ] = "";
	//%tex_chars["-poundsymbol"       ] = "";
	%tex_chars["-roundbracketleft"  ] = ")";
	%tex_chars["-roundbracketright" ] = "(";
	%tex_chars["-slashleft"         ] = "\\";
	%tex_chars["-slashright"        ] = "/";
	%tex_chars["-squarebracketleft" ] = "]";
	%tex_chars["-squarebracketright"] = "[";
	%tex_chars["-tilde"             ] = "~";
	//%tex_chars["-umlaut"            ] = "";
	%tex_chars["-underscore"        ] = "_";
	%tex_chars["-verticalbar"       ] = "|";
	%tex_chars["-backtick" ] = "`";
	%tex_chars["-semicolon"] = ";";
	%tex_chars["Alcase"] = "a";
	%tex_chars["Blcase"] = "b";
	%tex_chars["Clcase"] = "c";
	%tex_chars["Dlcase"] = "d";
	%tex_chars["Elcase"] = "e";
	%tex_chars["Flcase"] = "f";
	%tex_chars["Glcase"] = "g";
	%tex_chars["Hlcase"] = "h";
	%tex_chars["Ilcase"] = "i";
	%tex_chars["Jlcase"] = "j";
	%tex_chars["Klcase"] = "k";
	%tex_chars["Llcase"] = "l";
	%tex_chars["Mlcase"] = "m";
	%tex_chars["Nlcase"] = "n";
	%tex_chars["Olcase"] = "o";
	%tex_chars["Plcase"] = "p";
	%tex_chars["Qlcase"] = "q";
	%tex_chars["Rlcase"] = "r";
	%tex_chars["Slcase"] = "s";
	%tex_chars["Tlcase"] = "t";
	%tex_chars["Ulcase"] = "u";
	%tex_chars["Vlcase"] = "v";
	%tex_chars["Wlcase"] = "w";
	%tex_chars["Xlcase"] = "x";
	%tex_chars["Ylcase"] = "y";
	%tex_chars["Zlcase"] = "z";
	
	%count = getNumPrintTextures();
	for(%print_idx = 0; %print_idx < %count; %print_idx++) {
		%tex = getPrintTexture(%print_idx);
		if(strPos(%tex, "Print_Letters_") != -1) {
			// strip path and .png
			%tex = getSubStr(%tex, 0, strLen(%tex)-4);
			while(%pos = strPos(%tex, "/") != -1) {
				%tex = getSubStr(%tex, %pos, strLen(%tex) - %pos);
			}
			
			// insert into list
			%tc = %tex_chars[%tex];
			if(%tc !$= "") {
				if(strPos($bp_letters, %tc) == -1) {
					$bp_letters = $bp_letters @ getField(%tc, 0);
					$bp_fallback1 = $bp_fallback1 @ buildprint_getFieldOr(%tc, 1, "A");
					$bp_fallback2 = $bp_fallback2 @ buildprint_getFieldOr(%tc, 2, "A");
					$bp_fallback3 = $bp_fallback3 @ buildprint_getFieldOr(%tc, 3, "A");
					$bp_prints = $bp_prints SPC %print_idx;
				}
			}
		}
	}
	
	// trim leading space off $bp_prints
	$bp_prints = trim($bp_prints);
}
schedule(1, 0, buildprint_findprints);

function buildprint_getprint(%letter) {
	// i blame torquescript for this
	%cpos = strPos($bp_letters, %letter);
	if(%cpos==-1) {
		%cpos = strPos($bp_fallback1, %letter);
		if(%cpos == -1) {
			%cpos = strPos($bp_fallback2, %letter);
			if(%cpos == -1) {
				%cpos = strPos($bp_fallback3, %letter);
				if(%cpos == -1) {
					echo("buildprint_getprint: no print for letter " @ %letter);
					return "";
				}
			}
		}
	}
	return getWord($bp_prints, %cpos);
}

function buildprint_place(%client, %print, %shift) {
	%player = %client.player;
	if(!isObject(%player)) return;
	
	%player.tempBrick.setPrint(%print);
	serverCmdPlantBrick(%client);
	serverCmdSuperShiftBrick(%client,
		getWord(%shift, 0),
		getWord(%shift, 1),
		getWord(%shift, 2)
	);
}

function buildprint_start(%client, %switchcolor) {
	%client.buildprint_color0 = %client.currentColor;
	%client.buildprint_color1 = %client.currentColor+%switchcolor;
	
	%client.buildprint_linelen = 0;
}
function buildprint_switchcolor(%client) {
	%client.buildprint_coloridx = !%client.buildprint_coloridx;
	%color = %client.buildprint_color[%client.buildprint_coloridx];
	serverCmdUseSprayCan(%client, %color);
}

function buildprint_buildchar(%client, %letter, %shift, %shiftvert) {
	if(%letter $= "\r") {
		
	}else if(%letter $= "\n") {
		%len = %client.buildprint_linelen;
		
		serverCmdSuperShiftBrick(%client,
			getWord(%shiftvert, 0) - getWord(%shift, 0)*%len,
			getWord(%shiftvert, 1) - getWord(%shift, 1)*%len,
			getWord(%shiftvert, 2) - getWord(%shift, 2)*%len
		);
		%client.buildprint_linelen = 0;
		
		buildprint_switchcolor(%client);
	} else if(%letter $= "\t") {
		%tab_len = 4 - (%client.buildprint_linelen%4);
		for(%i=0; %i<%tab_len; %i++) {
			buildprint_buildchar(%client, " ", %shift, %shiftvert);
		}
	} else {
		%print = buildprint_getprint(%letter);
		if(%print $= "") { %print = buildprint_getprint("?"); }
		
		buildprint_place(%client, %print, %shift);
		%client.buildprint_linelen++;
	}
}

function serverCmdBp(%client, %m1, %m2, %m3, %m4, %m5, %m6, %m7, %m8, %m9, %m10, %m11, %m12, %m13, %m14, %m15, %m16, %m17, %m18, %m19, %m20) {
	serverCmdBuildPrint(%client, %m1, %m2, %m3, %m4, %m5, %m6, %m7, %m8, %m9, %m10, %m11, %m12, %m13, %m14, %m15, %m16, %m17, %m18, %m19, %m20);
}
function serverCmdBpV(%client, %m1, %m2, %m3, %m4, %m5, %m6, %m7, %m8, %m9, %m10, %m11, %m12, %m13, %m14, %m15, %m16, %m17, %m18, %m19, %m20) {
	serverCmdBuildPrintVertical(%client, %m1, %m2, %m3, %m4, %m5, %m6, %m7, %m8, %m9, %m10, %m11, %m12, %m13, %m14, %m15, %m16, %m17, %m18, %m19, %m20);
}

function serverCmdBuildPrint(%client, %m1, %m2, %m3, %m4, %m5, %m6, %m7, %m8, %m9, %m10, %m11, %m12, %m13, %m14, %m15, %m16, %m17, %m18, %m19, %m20) {
	%message = trim(%m1 SPC %m2 SPC %m3 SPC %m4 SPC %m5 SPC %m6 SPC %m7 SPC %m8 SPC %m9 SPC %m10 SPC %m11 SPC %m12 SPC %m13 SPC %m14 SPC %m15 SPC %m16 SPC %m17 SPC %m18 SPC %m19 SPC %m20) @ "\n";
	buildprint_start(%client, 0);
	serverCmdBuildPrint2(%client, %message, 0);
}
function serverCmdBuildPrintVertical(%client, %m1, %m2, %m3, %m4, %m5, %m6, %m7, %m8, %m9, %m10, %m11, %m12, %m13, %m14, %m15, %m16, %m17, %m18, %m19, %m20) {
	%message = trim(%m1 SPC %m2 SPC %m3 SPC %m4 SPC %m5 SPC %m6 SPC %m7 SPC %m8 SPC %m9 SPC %m10 SPC %m11 SPC %m12 SPC %m13 SPC %m14 SPC %m15 SPC %m16 SPC %m17 SPC %m18 SPC %m19 SPC %m20) @ "\n";
	buildprint_start(%client, 0);
	serverCmdBuildPrint2(%client, %message, 1);
}

function serverCmdBuildPrintStart(%client, %switchcolor) {
	buildprint_start(%client, %switchcolor);
}
function serverCmdBuildPrint2(%client, %message, %topdown) {
	if(!isObject(%client.player) || !isObject(%client.player.tempBrick)) { return; }
	
	%vertical = getWord(%client.player.getEyeVector(), 2)>-0.5;
	%shift = "0 -1 0";
	%shiftvert = %vertical ? "0 0 -1" : "-1 0 0";
	if(%topdown) { %s2 = %shift; %shift = %shiftvert; %shiftvert = %s2; }
	//talk(%topdown @ ", " @ %shift @ ", " @ %shiftvert);
	
	%len = strLen(%message);
	%len_line = 0;
	for(%idx=0; %idx<%len; %idx++) {
		%letter = getSubStr(%message, %idx, 1);
		buildprint_buildchar(%client, %letter, %shift, %shiftvert);
	}
}

// Center print command

function serverCmdCp(%client, %m1, %m2, %m3, %m4, %m5, %m6, %m7, %m8, %m9, %m10, %m11, %m12, %m13, %m14, %m15, %m16, %m17, %m18, %m19, %m20) {
	serverCmdCenterPrint(%client, %m1, %m2, %m3, %m4, %m5, %m6, %m7, %m8, %m9, %m10, %m11, %m12, %m13, %m14, %m15, %m16, %m17, %m18, %m19, %m20);
}

function serverCmdCenterPrint(%client, %m1, %m2, %m3, %m4, %m5, %m6, %m7, %m8, %m9, %m10, %m11, %m12, %m13, %m14, %m15, %m16, %m17, %m18, %m19, %m20) {
	%message = trim(%m1 SPC %m2 SPC %m3 SPC %m4 SPC %m5 SPC %m6 SPC %m7 SPC %m8 SPC %m9 SPC %m10 SPC %m11 SPC %m12 SPC %m13 SPC %m14 SPC %m15 SPC %m16 SPC %m17 SPC %m18 SPC %m19 SPC %m20) @ "\n";
	serverCmdCenterPrint2(%client, %message);
}

function serverCmdCenterPrint2(%client, %message) {
	%message = strReplace(trim(%message), "\n", "<br>");
	%player = %client.player;
	if(!isObject(%player)) { return; }
	
	%ray = containerRaycast(
		%player.getEyePoint(),
		vectorAdd(%player.getEyePoint(), vectorScale(%player.getEyeVector(), 20)),
		$TypeMasks::FxBrickObjectType,
		%player
	);
	%brick = getWord(%ray, 0);
	if(!isObject(%brick) || %brick.getClassName()!$="FxDtsBrick" || getTrustLevel(%brick, %client) < $TrustLevel::WrenchEvents) { return; }
	
	if(%brick.numEvents>1) { return; }
	if(%brick.numEvents==1) { %brick.numEvents = 0; }
	// %j = %brick.numEvents + 0;
	%j = 0;
	//%brick.numEvents++;
	%brick.numEvents = 1;
	
	%inputName = "onActivate";
	%targetName = "Client";
	%outputName = "CenterPrint";
	%param1 = "<font:times new roman:24><color:ffffff>" @ %message;
	%param2 = 3;
	%param3 = "";
	%param4 = "";
	
	// apply events
	
	%brick.implicitCancelEvents = 0;
	
	%inputIdx = inputEvent_GetInputEventIdx(%inputName);
	if(%inputIdx == -1) { warn("LOAD DUP: Input Event not found for name \"" @ %inputName @ "\""); return; }
	
	%targetIdx = inputEvent_GetTargetIndex("FxDtsBrick", %inputIdx, %targetName);
	if(%targetName == -1) {
		%targetClass = "FxDtsBrick";
	} else {
		%field = getField($InputEvent_TargetList["FxDtsBrick", %inputIdx], %targetIdx);
		%targetClass = getWord(%field, 1);
	}
	
	%outputIdx = outputEvent_GetOutputEventIdx(%targetClass, %outputName);
	if(%outputIdx == -1) { warn("LOAD DUP: Output Event not found for name \"" @ %outputName @ "\""); return; }
	
	%brick.eventEnabled[%j] = 1;
	%brick.eventDelay[%j] = 0;
	%brick.eventInput[%j] = %inputName;
	%brick.eventInputIdx[%j] = %inputIdx;
	%brick.eventTarget[%j] = %targetName;
	%brick.eventTargetIdx[%j] = %targetIdx;
	%brick.eventOutput[%j] = %outputName;
	%brick.eventOutputIdx[%j] = %outputIdx;
	%brick.eventOutputParameter[%j, 1] = %param1;
	%brick.eventOutputParameter[%j, 2] = %param2;
	%brick.eventOutputParameter[%j, 3] = %param3;
	%brick.eventOutputParameter[%j, 4] = %param4;
	%brick.eventOutputAppendClient[%j] = 1;
}
