//ZoneEvents v12 - Made By Melting Plastic (id 799)
//
//updated 3/11/2013
//	Compatable With Bot Holes
//	Fixed Console Spam when clearing bricks
//
//updated 1/13/2013
//	Fixed onPlayerLeaveZone
//	Fixed and added targets for vehicle owners, bot owners and brick owners.
//  Event client ownership fixed to reflect the drivers clients not the brick group clients when possible.
//  Some saved events may need to be renamed.
//
//updated 1/12/2013
//	ZeroGravity and Drag now Works with vehicles
//
//updated 1/10/2013
//	Zone forces now work on vehicles (can be turned off with rtb pref)
//  Code Cleaning
//
//updated 8/19/2012
//	Hopefully fixed some target issues
//	renamed onInZone targets to be more clear
//	added All_Players(Clients) to onInZone
//	added TickRate in the rtb prefs(host only)
//
//updated 3/8/2012
//	Fixed Some Target Issues
//	onPlayerLeaveZone is now triggered by players dying inside the zone
//
//updated 3/28/2011
//	Flying Vehicles (magic carpets) and skiis now work
//
//updated 12/29/2010
//	OninZone Now works with many Targets.
//



//RTB PREFS
if(isFile("Add-Ons/System_oRBs/server.cs")) 
{ 
	if(!$ORBS::ORBSR_ServerControl_Hook) 
	{
		exec("Add-Ons/System_oRBs/ORBSR_ServerControl_Hook.cs"); 
	}
	ORBS_registerPref( "TickRate", "ZoneEvents", "$ZoneEvents::TickRate", "int 10 2000", "Event_Zones", "200", 1, 1);
	ORBS_registerPref( "DoImpulseVehicles", "ZoneEvents", "$ZoneEvents::DoImpulseVehicles", "bool 0 1", "Event_Zones", "1", 0, 1);
} 
else 
{
	$ZoneEvents::TickRate = 200;
	$ZoneEvents::DoImpulseVehicles = 1;
}

//Inputs
registerInputEvent("fxDTSBrick","onPlayerEnterZone","Self fxDTSBrick" TAB "Player Player" TAB "Client GameConnection" TAB "MiniGame MiniGame" TAB "Brick_Owner(Player) Player" TAB "Brick_Owner(Client) GameConnection");
registerInputEvent("fxDTSBrick","onBotEnterZone","Self fxDTSBrick" TAB "Bot Bot" TAB "Driver(Client) GameConnection" TAB "Driver(Player) Player" TAB "MiniGame MiniGame" TAB "Brick_Owner(Player) Player" TAB "Brick_Owner(Client) GameConnection" TAB "Bot_Owner(Player) Player" TAB "Bot_Owner(Client) GameConnection");
registerInputEvent("fxDTSBrick","onVehicleEnterZone","Self fxDTSBrick" TAB "Vehicle Vehicle" TAB "Driver(Client) GameConnection" TAB "Driver(Player) Player" TAB "MiniGame MiniGame" TAB "Vehicle_Owner(Player) Player" TAB "Vehicle_Owner(Client) GameConnection" TAB "Brick_Owner(Player) Player" TAB "Brick_Owner(Client) GameConnection");

registerInputEvent("fxDTSBrick","onPlayerleaveZone","Self fxDTSBrick" TAB "Player Player" TAB "Client GameConnection" TAB "MiniGame MiniGame" TAB "Brick_Owner(Player) Player" TAB "Brick_Owner(Client) GameConnection");
registerInputEvent("fxDTSBrick","onBotLeaveZone","Self fxDTSBrick" TAB "Bot Bot" TAB "Driver(Client) GameConnection" TAB "Driver(Player) Player" TAB "MiniGame MiniGame" TAB "Brick_Owner(Player) Player" TAB "Brick_Owner(Client) GameConnection" TAB "Bot_Owner(Player) Player" TAB "Bot_Owner(Client) GameConnection");
registerInputEvent("fxDTSBrick","onVehicleLeaveZone","Self fxDTSBrick" TAB "Vehicle Vehicle" TAB "Driver(Client) GameConnection" TAB "Driver(Player) Player" TAB "MiniGame MiniGame" TAB "Vehicle_Owner(Player) Player" TAB "Vehicle_Owner(Client) GameConnection" TAB "Brick_Owner(Player) Player" TAB "Brick_Owner(Client) GameConnection");

registerInputEvent("fxDTSBrick","onInZone","Self fxDTSBrick" TAB "All_Players Player" TAB "All_Players(Clients) GameConnection" TAB "All_Bots Player" TAB "All_Vehicles Vehicle" TAB "All_Drivers(Clients) GameConnection" TAB "All_Drivers(Players) Player" TAB "MiniGame MiniGame");


//Outputs
registerOutputEvent(fxDTSBrick, setZone, "list NONE 7 Up 1 Down 2 North 3 South 4 East 5 West 6 Center 0" TAB "int 0.0 400.0 10"  TAB "vector 40000 -40000 0" , 1);
registerOutputEvent(fxDTSBrick, setZoneActive);
registerOutputEvent(fxDTSBrick, setZoneUnActive);
registerOutputEvent(fxDTSBrick, setZoneGravity, "string 5 20" , 1);
registerOutputEvent(fxDTSBrick, setZoneDrag, "int -50 50 0" , 1);
registerOutputEvent(fxDTSBrick, setZoneVelocityMod, "float -5 5 0.1 1" , 1);
registerOutputEvent(fxDTSBrick, setZoneIsWater, "bool 0" , 1);
registerOutputEvent(fxDTSBrick, setZoneWaterViscosity, "int -200 200 40" , 1);
registerOutputEvent(fxDTSBrick, setZoneWaterDensity, "int -40 40 1" , 1);
registerOutputEvent(fxDTSBrick, setZoneBox, "vector 200 -200 0" TAB "vector 200 -200 0" TAB "vector 40000 -40000 0", 1);


datablock TriggerData(zoneTrigger)
{
	tickPeriodMS = $ZoneEvents::TickRate;
};


package ZoneEvents
{
	//Trigger Methods
	//on tick trigger gives no info on WHAt is in the zone...
	//an array is used to store object values for each trigger.
	
	function zoneTrigger::onTickTrigger(%this,%trigger)
	{
		if(%trigger.Active == 1)
		{		
				//We need to call the function OninZone FOR EVERY OBJECT iN THE ZONE..
				for(%n = 0; %n < 10; %n = %n + 1) 
				{
					%CurrentObject = %trigger.ObjArray[%n];
					
					if(isObject(%CurrentObject))
					{
						%trigger.triggerBrick.onInZone(%CurrentObject);
					}
				}
		}
	}

	function zoneTrigger::onEnterTrigger(%this,%trigger,%obj)
	{
		if(%trigger.Active == 1)
		{	
			if(%obj.getClassName() $= "AIPlayer")
			{
				
				%trigger.triggerBrick.onBotEnterZone(%obj);
				
			}
			else if(%obj.getClassName() $= "Player")
			{
				%trigger.triggerBrick.onPlayerEnterZone(%obj);
				
			}
			else if((%obj.getClassName() $= "WheeledVehicle") || (%obj.getClassName() $= "FlyingVehicle"))
			{
				%trigger.triggerBrick.onVehicleEnterZone(%obj);
			}
			//find an empty slot..
			for(%n = 0; %n < 10; %n++)
			{
				
				//If the Slot is empty
				if(!isobject(%trigger.ObjArray[%n]))
				{
					%trigger.ObjArray[%n] = %obj; //Put our object in that empty slot.
					
					%n = 10; //stop the loop.
				}
			}
		}
	}
	function zoneTrigger::onLeaveTrigger(%this,%trigger,%obj)
	{
	if(%trigger.Active == 1)
	{
		
		if(%obj.getClassName() $= "AIPlayer")
		{	
			%trigger.triggerBrick.onBotLeaveZone(%obj);
		}
		else if(%obj.getClassName() $= "Player")
		{	
			%trigger.triggerBrick.onPlayerLeaveZone(%obj);
		}
		else if((%obj.getClassName() $= "WheeledVehicle") || (%obj.getClassName() $= "FlyingVehicle"))
		{
			%trigger.triggerBrick.onVehicleLeaveZone(%obj);	
		}
		
		//find the slot that is already holding this object!
		for(%n = 0; %n < 10; %n++)
		{	
			//If the Slot is Full with the match
			if(%trigger.ObjArray[%n] == %Obj)
			{
				%trigger.ObjArray[%n] = null; //remove it from the list.
			}
		}
	}
	}
	function fxDTSBrick::onPlayerEnterZone(%obj,%player)
	{	
		//obj is the brick!
		if(isObject(%obj.trigger) && %obj.trigger.istriggerBricktrigger == 1)
		{
			//store this brick on the player just in case he dies we can call onplayerleavezone.
			%player.numinzones++;
			%player.insidezone[%player.insidezoneidx] = %obj; 
			%player.insidezoneidx++;
			
			$InputTarget_["Self"] = %obj;
			$InputTarget_["Player"] = %player;
			$InputTarget_["Client"] = %player.client;

			if(%obj.getGroup().client.minigame)
			{
				$InputTarget_["MiniGame"] = %obj.getGroup().client.minigame;
			}
			$InputTarget_["Brick_Owner(Player)"] = %obj.getGroup().client.Player;
			$InputTarget_["Brick_Owner(Client)"] = %obj.getGroup().client;
			
			%obj.processInputEvent("onPlayerEnterZone",%player.client);
		}
	}
	
	function fxDTSBrick::onBotEnterZone(%obj,%bot)
	{
		//obj is the brick!
		if(isObject(%obj.trigger) && %obj.trigger.istriggerBricktrigger == 1)
		{
			$InputTarget_["Self"] = %obj;
			$InputTarget_["Bot"] = %bot;
			if(isObject(%bot.getControllingClient()))
			{
				$InputTarget_["Driver(Client)"] = %bot.getControllingClient();
				$InputTarget_["Driver(Player)"] = %bot.getControllingObject();
			}
			if(%obj.getGroup().client.minigame)
			{
				$InputTarget_["MiniGame"] = %obj.getGroup().client.minigame;
			}

			$InputTarget_["Brick_Owner(Player)"] = %obj.getGroup().client.Player;
			$InputTarget_["Brick_Owner(Client)"] = %obj.getGroup().client;
			
			$InputTarget_["Bot_Owner(Player)"] = %bot.spawnBrick.getGroup().client.player;
			$InputTarget_["Bot_Owner(Client)"] = %bot.spawnBrick.getGroup().client;
			
			if(isObject(%bot.getControllingClient()))
			{
				%obj.processInputEvent("onBotEnterZone",%bot.getControllingClient());
			}
			else
			{
				%obj.processInputEvent("onBotEnterZone",%bot.spawnBrick.getGroup().client);
			}
		}
	}
	function fxDTSBrick::onVehicleEnterZone(%obj,%vehicle)
	{	
		//obj is the brick!
		if(isObject(%obj.trigger) && %obj.trigger.istriggerBricktrigger == 1)
		{
			%DriverClient = "";
			%DriverPlayer = "";
			%VehicleOwnerClient = "";
			%VehicleOwnerPlayer = "";
			%BrickOwnerClient = %obj.getGroup().client;
			%BrickOwnerPlayer = %obj.getGroup().client.player;
			
			//Figure Out Driver---------------------------------
			if(isObject(%vehicle.getControllingClient()))
			{
				%DriverClient = %vehicle.getControllingClient();
			}
			else//the vehicle may be skiis or there is no driver..
			{
				if(isObject(%vehicle.client))
				{
					%DriverClient = %vehicle.client;
				}
				//otherwise leave the DriverClient empty...
			}
			%DriverPlayer = %DriverClient.player;
		
			//Figure Out Owner-----------------------------------
			if(IsObject(%vehicle.brickGroup))
			{
				%OwnerClient = %vehicle.brickGroup.client;
			}
			else//if skiis, Owner is driver..
			{
				if(IsObject(%vehicle.client))
				{
					%OwnerClient = %vehicle.client;
				}
			}
			%OwnerPlayer = %OwnerClient.player;
		
		
		
			$InputTarget_["Self"] = %obj;
			$InputTarget_["Vehicle"] = %vehicle;
			
			
			
			$InputTarget_["Driver(Client)"] = %DriverClient;
			$InputTarget_["Driver(Player)"] = %DriverPlayer;
			
			$InputTarget_["MiniGame"] = %OwnerClient.minigame;
			
			$InputTarget_["Vehicle_Owner(Player)"] = %OwnerPlayer;
			$InputTarget_["Vehicle_Owner(Client)"] = %OwnerClient;
			
			$InputTarget_["Brick_Owner(Client)"] = %BrickOwnerClient;
			$InputTarget_["Brick_Owner(player)"] = %BrickOwnerPlayer;
	
			if(isObject(%DriverClient))//driver client.
			{	
				%obj.processInputEvent("onVehicleEnterZone",%DriverClient);
			}
			else//try the .client field used with skiis - if not settle for brick group owner.
			{
				%obj.processInputEvent("onVehicleEnterZone",%OwnerClient);
			}
		}
		
	}
	function fxDTSBrick::onPlayerLeaveZone(%obj,%player)
	{
		//obj is the brick!
		
		if(isObject(%obj.trigger) && %obj.trigger.istriggerBricktrigger == 1)
		{
			%player.numinzones--;
			//remove this bricks reference on the player.
			for(%i=0; %i<%player.insidezoneidx; %i++)
			{
				if(%player.insidezone[%i] == %obj)
				{
					%player.insidezone[%i] = ""; 
				}
			}
			if(%player.numinzones <= 0)
			{
				%player.insidezoneidx=0;
				%player.insidezone = "";
			}
		
			
			$InputTarget_["Self"] = %obj;
			$InputTarget_["Player"] = %player;
			$InputTarget_["Client"] = %player.client;

			if(%obj.getGroup().client.minigame)
			{
				$InputTarget_["MiniGame"] = %obj.getGroup().client.minigame;
			}

			$InputTarget_["Brick_Owner(Player)"] = %obj.getGroup().client.Player;
			$InputTarget_["Brick_Owner(Client)"] = %obj.getGroup().client;
			%obj.processInputEvent("onPlayerLeaveZone",%player.client);
		}
	}
	function fxDTSBrick::onBotLeaveZone(%obj,%bot)
	{	
		//obj is the brick!
		if(isObject(%obj.trigger) && %obj.trigger.istriggerBricktrigger == 1)
		{
			$InputTarget_["Self"] = %obj;
			$InputTarget_["Bot"] = %bot;
			if(isObject(%bot.getControllingClient()))
			{
				$InputTarget_["Driver(Client)"] = %bot.getControllingClient();
				$InputTarget_["Driver(Player)"] = %bot.getControllingObject();
			}
			if(%obj.getGroup().client.minigame)
			{
				$InputTarget_["MiniGame"] = %obj.getGroup().client.minigame;
			}

			$InputTarget_["Brick_Owner(Player)"] = %obj.getGroup().client.Player;
			$InputTarget_["Brick_Owner(Client)"] = %obj.getGroup().client;
			
			$InputTarget_["Bot_Owner(Player)"] = %bot.spawnBrick.getGroup().client.player;
			$InputTarget_["Bot_Owner(Client)"] = %bot.spawnBrick.getGroup().client;
			
			if(isObject(%bot.getControllingClient()))
			{
				%obj.processInputEvent("onBotLeaveZone",%bot.getControllingClient());
			}
			else
			{
				%obj.processInputEvent("onBotLeaveZone",%bot.spawnBrick.getGroup().client);
			}
		}
	}
	function fxDTSBrick::onVehicleLeaveZone(%obj,%Vehicle)
	{
		//obj is the brick!
		if(isObject(%obj.trigger) && %obj.trigger.istriggerBricktrigger == 1)
		{
			%DriverClient = "";
			%DriverPlayer = "";
			%VehicleOwnerClient = "";
			%VehicleOwnerPlayer = "";
			%BrickOwnerClient = %obj.getGroup().client;
			%BrickOwnerPlayer = %obj.getGroup().client.player;
			
			//Figure Out Driver---------------------------------
			if(isObject(%vehicle.getControllingClient()))
			{
				%DriverClient = %vehicle.getControllingClient();
			}
			else//the vehicle may be skiis or there is no driver..
			{
				if(isObject(%vehicle.client))
				{
					%DriverClient = %vehicle.client;
				}
				//otherwise leave the DriverClient empty...
			}
			%DriverPlayer = %DriverClient.player;
		
			//Figure Out Owner-----------------------------------
			if(IsObject(%vehicle.brickGroup))
			{
				%OwnerClient = %vehicle.brickGroup.client;
			}
			else//if skiis, Owner is driver..
			{
				if(IsObject(%vehicle.client))
				{
					%OwnerClient = %vehicle.client;
				}
			}
			%OwnerPlayer = %OwnerClient.player;
		
		
		
			$InputTarget_["Self"] = %obj;
			$InputTarget_["Vehicle"] = %vehicle;
			
			
			
			$InputTarget_["Driver(Client)"] = %DriverClient;
			$InputTarget_["Driver(Player)"] = %DriverPlayer;
			
			$InputTarget_["MiniGame"] = %OwnerClient.minigame;
			
			$InputTarget_["Vehicle_Owner(Player)"] = %OwnerPlayer;
			$InputTarget_["Vehicle_Owner(Client)"] = %OwnerClient;
			
			$InputTarget_["Brick_Owner(Client)"] = %BrickOwnerClient;
			$InputTarget_["Brick_Owner(player)"] = %BrickOwnerPlayer;
	
			if(isObject(%DriverClient))//driver client.
			{	
				%obj.processInputEvent("onVehicleLeaveZone",%DriverClient);
			}
			else//try the .client field used with skiis - if not settle for brick group owner.
			{
				%obj.processInputEvent("onVehicleLeaveZone",%OwnerClient);
			}
		}
	}
	function fxDTSBrick::onInZone(%obj,%LastObj)
	{
		//We Have to reset because this function is called many times each tick depending on how many objects are inside, this clears the slate to start off.
		$InputTarget_["All_Players"] = null;
		$InputTarget_["All_Players(Clients)"] = null;
		$InputTarget_["All_Bots"] = null;
		$InputTarget_["All_Vehicles"] = null;
		$InputTarget_["All_Drivers(Clients)"] = null;
		$InputTarget_["All_Drivers(Players)"] = null;
		
		//obj is the brick!
		if(isObject(%obj.trigger) && %obj.trigger.istriggerBricktrigger == 1)
		{
			if(%obj.getGroup().client.minigame)
			{
				$InputTarget_["MiniGame"] = %obj.getGroup().client.minigame;
			}
			
			$InputTarget_["Self"] = %obj;
			
			if(isObject(%LastObj))
			{
				if(%LastObj.getClassName() $= "Player")
				{	
					$InputTarget_["All_Players"] = %LastObj;
					$InputTarget_["All_Players(Clients)"] = %LastObj.client;
				}
				if(%LastObj.getClassName() $= "AIPlayer")
				{
					
					$InputTarget_["All_Bots"] = %LastObj;
					if(isObject(%LastObj.getControllingObject()))
					{
						$InputTarget_["All_Drivers(Clients)"] = %LastObj.getControllingClient();
						$InputTarget_["All_Drivers(Players)"] = %LastObj.getControllingClient().Player;
					}
				}
				if(%LastObj.getClassName() $= "WheeledVehicle" || %LastObj.getClassName() $= "FlyingVehicle")
				{
					if($ZoneEvents::DoImpulseVehicles == 1)
					{
						ImpulseVehicleWithZone(%LastObj,%obj);
					}
					
					$InputTarget_["All_Vehicles"] = %LastObj;
					if(isObject(%LastObj.getControllingObject()))
					{
						$InputTarget_["All_Drivers(Clients)"] = %LastObj.getControllingClient();
						$InputTarget_["All_Drivers(Players)"] = %LastObj.getControllingClient().Player;
					}
				}
			}
			%obj.processInputEvent("onInZone",%obj.getGroup().client);
		}
	}
	



function mMin(%a, %b) { return %a<%b ? %a : %b; }
function mMax(%a, %b) { return %a>%b ? %a : %b; }

//Output Functions--------------------------------------------------------------------------------------------------
	function fxDtsBrick::setZoneBox(%brick, %p1r, %p2r, %vector, %client) {
		// Absolutize and normalize world box
		%pos = %brick.getPosition();
		%p1u = vectorAdd(%pos, %p1r);
		%p2u = vectorAdd(%pos, %p2r);
		%p1 = mMin(getWord(%p1u, 0), getWord(%p2u, 0)) SPC 
		      mMin(getWord(%p1u, 1), getWord(%p2u, 1)) SPC 
		      mMin(getWord(%p1u, 2), getWord(%p2u, 2));
		%p2 = mMax(getWord(%p1u, 0), getWord(%p2u, 0)) SPC 
		      mMax(getWord(%p1u, 1), getWord(%p2u, 1)) SPC 
		      mMax(getWord(%p1u, 2), getWord(%p2u, 2));
		
		// Apply to brick
		%brick.setZone(0, 0, %vector, %client, %p1, %p2);
	}
	
	function fxDTSBrick::setZone(%brick, %dir, %Addition, %vector, %client, %p1, %p2)
	{
		//delete old physical zones and triggers belonging to the brick
		if(isObject(%brick.physicalZone))
		{
			%brick.physicalZone.delete();
		}
		if(isObject(%brick.trigger))
		{
			ez_removeZone(%brick.trigger);
			%brick.trigger.delete();
			
		}
		if(%dir <= 6)
		{
		
				if(%dir == 0)
				{
					
					%xOffset = 0;
					%yOffset = 0;
					%zOffset = 0;
					
					if(%p1 $= "") {
						%p1 = getWords(%brick.getWorldBox(), 0, 2);
						%p2 = getWords(%brick.getWorldBox(), 3, 5);
					}
					
					%zoneXa = getWord(%p1, 0) - %Addition/10;
					%zoneYa = getWord(%p1, 1) - %Addition/10;
					%zoneZa = getWord(%p1, 2) - %Addition/10;
					
					%zoneXsize =  getWord(%p2, 0) - getWord(%p1, 0) + %Addition/5;
					%zoneYsize =  getWord(%p2, 1) - getWord(%p1, 1) + %Addition/5;
					%zoneZsize = (getWord(%p2, 2) - getWord(%p1, 2)) + %Addition/5;
					
					%zoneYa = %zoneYa + %zoneYsize;
				
				}
				if(%dir == 1)
				{	
					%Addition = %Addition * 0.5555;
					%xOffset = 0;
					%yOffset = 0;
					%zOffset = %Addition;
					
					
					%zoneXa = getWord(%brick.getWorldBox(), 0);
					%zoneYa = getWord(%brick.getWorldBox(), 1);
					%zoneZa = getWord(%brick.getWorldBox(), 2);
					
					%zoneXsize = getWord(%brick.getWorldBox(), 3) - getWord(%brick.getWorldBox(), 0);
					%zoneYsize = getWord(%brick.getWorldBox(), 4) - getWord(%brick.getWorldBox(), 1);
					%zoneZsize = (getWord(%brick.getWorldBox(), 5) - getWord(%brick.getWorldBox(), 2)) + %zOffset;
					
					%zoneYa = %zoneYa + %zoneYsize;
					
				
				}
				if(%dir == 2)
				{
					%Addition = %Addition * 0.5555;
					%xOffset = 0;
					%yOffset = 0;
					%zOffset = %Addition;
					
					%zoneXsize = getWord(%brick.getWorldBox(), 3) - getWord(%brick.getWorldBox(), 0);
					%zoneYsize = getWord(%brick.getWorldBox(), 4) - getWord(%brick.getWorldBox(), 1);
					%zoneZsize = ((getWord(%brick.getWorldBox(), 5) - getWord(%brick.getWorldBox(), 2)) + %zOffset);
					
					%zoneXa = getWord(%brick.getWorldBox(), 0);
					%zoneYa = getWord(%brick.getWorldBox(), 1);
					%zoneZa = getWord(%brick.getWorldBox(), 5);
					
					%zoneZa = %zoneZa - %zoneZsize;
					%zoneYa = %zoneYa + %zoneYsize;
				}
		
				if(%dir == 3)
				{
					%Addition = %Addition * 0.5;
					%xOffset = 0;
					%yOffset = %Addition;
					%zOffset = 0;
					
					
					%zoneXa = getWord(%brick.getWorldBox(), 0);
					%zoneYa = getWord(%brick.getWorldBox(), 1);
					%zoneZa = getWord(%brick.getWorldBox(), 2);
					
					%zoneXsize = getWord(%brick.getWorldBox(), 3) - getWord(%brick.getWorldBox(), 0);
					%zoneYsize = (getWord(%brick.getWorldBox(), 4) - getWord(%brick.getWorldBox(), 1)) + %yOffset;
					%zoneZsize = (getWord(%brick.getWorldBox(), 5) - getWord(%brick.getWorldBox(), 2));
					
					%zoneYa = %zoneYa + %zoneYsize;
				
				}
				if(%dir == 4)
				{
					%Addition = %Addition * 0.5;
					%xOffset = 0;
					%yOffset = %Addition;
					%zOffset = 0;
					
					
					%zoneXa = getWord(%brick.getWorldBox(), 0);
					%zoneYa = getWord(%brick.getWorldBox(), 4);
					%zoneZa = getWord(%brick.getWorldBox(), 2);
					
					%zoneXsize = getWord(%brick.getWorldBox(), 3) - getWord(%brick.getWorldBox(), 0);
					%zoneYsize = (getWord(%brick.getWorldBox(), 4) - getWord(%brick.getWorldBox(), 1)) + %yOffset;
					%zoneZsize = (getWord(%brick.getWorldBox(), 5) - getWord(%brick.getWorldBox(), 2));
					
				
				
				}
				if(%dir == 5)
				{
					%Addition = %Addition * 0.5;
					%xOffset = %Addition;
					%yOffset = 0;
					%zOffset = 0;
					
					
					%zoneXa = getWord(%brick.getWorldBox(), 0);
					%zoneYa = getWord(%brick.getWorldBox(), 1);
					%zoneZa = getWord(%brick.getWorldBox(), 2);
					
					%zoneXsize = getWord(%brick.getWorldBox(), 3) - getWord(%brick.getWorldBox(), 0) + %xOffset;
					%zoneYsize = getWord(%brick.getWorldBox(), 4) - getWord(%brick.getWorldBox(), 1);
					%zoneZsize = (getWord(%brick.getWorldBox(), 5) - getWord(%brick.getWorldBox(), 2));
					
					%zoneYa = %zoneYa + %zoneYsize;
				
				}
				if(%dir == 6)
				{
					%Addition = %Addition * 0.5;
					%xOffset = %Addition;
					%yOffset = 0;
					%zOffset = 0;
					
					
					%zoneXa = getWord(%brick.getWorldBox(), 3);
					%zoneYa = getWord(%brick.getWorldBox(), 1);
					%zoneZa = getWord(%brick.getWorldBox(), 2);
					
					%zoneXsize = getWord(%brick.getWorldBox(), 3) - getWord(%brick.getWorldBox(), 0) + %xOffset;
					%zoneYsize = getWord(%brick.getWorldBox(), 4) - getWord(%brick.getWorldBox(), 1);
					%zoneZsize = (getWord(%brick.getWorldBox(), 5) - getWord(%brick.getWorldBox(), 2));
					
					%zoneYa = %zoneYa + %zoneYsize;
					%zoneXa = %zoneXa - %zoneXsize;
				}
		
				%polySuffA = 0;
				%zoneShape = "0.0 0.0 0.0 1.0 0.0 0.0 0.0 -1.0 0.0 0.0 0.0 1.0";
				
				
				%pz = new PhysicalZone()
				{
				  position = %zoneXa SPC %zoneYa SPC %zoneZa;
				  velocityMod = "1";
				  gravityMod = "1";
				  extraDrag = "0";
				  isWater = "0";
				  waterViscosity = "40";
				  waterDensity = "1";
				  waterColor = "0.200000 0.600000 0.600000 0.300000";
				  appliedForce = %vector;
				  polyhedron = %zoneShape;
					brick = %brick;
				};
				missionCleanup.add(%pz);
		

				//Create a new trigger
				%tr = new trigger()
				{
				  position = %zoneXa SPC %zoneYa SPC %zoneZa;
				  polyhedron = %zoneShape;
				  dataBlock = zoneTrigger;
				  brick = %brick;
				};
				missionCleanup.add(%tr);
				

				


				//we already have created both the physicalzone and the trigger 
				//- now we stretch them to the sizes depicted above.
				
				%pz.setScale(%zoneXsize SPC %zoneYsize SPC %zoneZsize);
				%tr.setScale(%zoneXsize SPC %zoneYsize SPC %zoneZsize);
				
				if(!isObject(%pz))
				{
					error("Zone Events ERROR: Could not create physical zone for This brick!, There are probably to many in the server!");
					return;
				}
			
				//Important Variables right here:!!
				%brick.IsZoneBrick = 1;
				%brick.physicalZone = %pz;
				
				%brick.trigger = %tr;				
				%brick.trigger.Active = 1;
				%tr.istriggerBricktrigger = 1;
				%tr.triggerBrick = %brick;   //this helps us find the brick the trigger is connected to.
				
				ez_addZone(%tr);
				
		}
		if(%dir == 7)
		{
			%brick.IsZoneBrick = 0;
		}
	}


//
function fxDTSBrick::RemoveZone(%brick)
{
	ez_removeZone(%brick.trigger);
	
	%brick.physicalZone.delete();
	%brick.physicalZone = NULL;
	%brick.trigger.delete();
	%brick.trigger = NULL;
	%brick.IsZoneBrick = 0;
}




function fxDTSBrick::setZoneActive(%brick,%client)
{
	if(%brick.isZoneBrick == 1)
	{
	%brick.physicalZone.activate();
	%brick.trigger.active = 1;
	}
}

function fxDTSBrick::setZoneUnActive(%brick,%client)
{
	if(%brick.isZoneBrick == 1)
	{
	%brick.physicalZone.deactivate();
	%brick.trigger.active = 0;
	}
}
function fxDTSBrick::setZoneGravity(%brick,%force,%client)
{
	if(%brick.isZoneBrick == 1)
	{
	%brick.physicalZone.gravityMod = %force;
	}
}

function fxDTSBrick::setZoneDrag(%brick,%drag,%client)
{
	if(%brick.isZoneBrick == 1)
	{
	%brick.physicalZone.extraDrag = %drag;
	}
}

function fxDTSBrick::setZoneVelocityMod(%brick,%vel,%client)
{
	if(%brick.isZoneBrick == 1)
	{
	%brick.physicalZone.velocityMod = %vel;
	}
}


function fxDTSBrick::setZoneIsWater(%brick,%water,%client)
{
	if(%brick.isZoneBrick == 1)
	{
	
	//This helps when using Traders Water events
	
	%brick.physicalZone.iswaterBrickwater = 1;
	%brick.physicalZone.waterBrick = %brick;
	
	%color = getColorIDTable(%brick.colorID);
        %rgb = getWords(%color, 0, 2);
        %a = getWord(%color, 3) / 0.5;
	%brick.physicalZone.isWater = %water;
	%brick.PhysicalZone.setWaterColor(%rgb SPC %a);
	}
}

function fxDTSBrick::setZoneWaterViscosity(%brick,%Viscosity,%client)
{
	if(%brick.isZoneBrick == 1)
	{
	%brick.physicalZone.waterViscosity = %Viscosity;
	}
}


function fxDTSBrick::setZoneWaterDensity(%brick,%density,%client)
{
	if(%brick.isZoneBrick == 1)
	{
	%brick.physicalZone.waterDensity = %density;
	}
}


function fxDTSBrick::onDeath(%brick)
{
	Parent::onDeath(%brick);
	if(%brick.isZoneBrick == 1)
	{
		%brick.RemoveZone();
	}
}


function fxDTSBrick::onRemove(%brick)
{
	Parent::onRemove(%brick);
	if(%brick.isZoneBrick == 1)
	{
		%brick.RemoveZone();
	}
		
}

function fxDTSBrick::onFakeDeath(%brick)
{
	Parent::onFakeDeath(%brick);
	%brick.setZoneUnActive(%brick); 
   

   
}



function fxDTSBrick::onClearFakeDeath(%this)
{
   Parent::onClearFakeDeath(%this);
  
	    %this.setZoneActive(%this);
}
function fxDTSBrick::onColorChange(%this)
{
        Parent::onColorChange(%this);
	if(%this.isZoneBrick == 1)
	{
	%color = getColorIDTable(%this.colorID);
        %rgb = getWords(%color, 0, 2);
        %a = getWord(%color, 3) / 0.5;

	%this.PhysicalZone.setWaterColor(%rgb SPC %a);
	}
}


//We need to notify the correct zone when somebody dies inside a zone. - call onplayerleavezone
function gameConnection::onDeath(%client,%source,%killer,%type,%location)
{
	
	if(isObject(%client.player))
	{
		for(%i=0;%i<%client.player.insidezoneidx;%i++)
		{
			if(IsObject(%client.player.insidezone[%i]))
			{
			%client.player.insidezone[%i].onPlayerLeaveZone(%client);
			}
		
		}
	}
	Parent::onDeath(%client,%source,%killer,%type,%location);
}


function ImpulseVehicleWithZone(%vehicle,%zonebrick)
{

	if(!%zonebrick.isZoneBrick)
	{
		return;
	}
	if((VectorLen(%zonebrick.physicalzone.appliedForce) == 0) && (%zonebrick.physicalzone.gravitymod == 1) && (%zonebrick.physicalzone.extraDrag == 0))
	{
		return;
	}
	
	%ZoneGravityMod = %zonebrick.physicalzone.gravitymod*10;
	%DragFactor = %zonebrick.physicalzone.extraDrag/30;
	%VehicleMassFactor = %vehicle.GetDatablock().mass*0.004;
	%TimingFactor = 200*0.5;
	%ZoneForceImpulseScale = %TimingFactor * 0.01 * 0.5;
	%GravTrim = 1;
	
	
	%ZoneForceImpulseX = getWord(%zonebrick.physicalzone.appliedForce,0)*%ZoneForceImpulseScale;
	%ZoneForceImpulseY = getWord(%zonebrick.physicalzone.appliedForce,1)*%ZoneForceImpulseScale;
	%ZoneForceImpulseZ = getWord(%zonebrick.physicalzone.appliedForce,2)*%ZoneForceImpulseScale;
	%ZoneForceImpulse = %ZoneForceImpulseX SPC %ZoneForceImpulseY SPC %ZoneForceImpulseZ;

	%ZoneGravityImpulseX = 0;
	%ZoneGravityImpulseY = 0;
	%ZoneGravityImpulseZ = (-(%ZoneGravityMod - 1))*%VehicleMassFactor*%TimingFactor*%GravTrim;//if grav mod is 1 then nothing changes!
	%ZoneGravityImpulse = %ZoneGravityImpulseX SPC %ZoneGravityImpulseY SPC %ZoneGravityImpulseZ;
	

	
	
	
	%ResultantImpulse = VectorAdd(%ZoneForceImpulse,%ZoneGravityImpulse);
	%vehicle.applyImpulse(getWords(%vehicle.getTransform(),0,2) ,%ResultantImpulse);
	
	//drag stuff
	if(%DragFactor != 0)
	{
		//velocity modifiers..
		%ZoneDragVel = VectorScale(%vehicle.getVelocity(),-1*%DragFactor);
		if(VectorLen(%ZoneDragVel) >= VectorLen(%vehicle.getVelocity()))//maximum drag
		{
			%ZoneDragVel = VectorScale(%vehicle.getVelocity(),-1);
		}
		
		%vehicle.setVelocity(%ZoneDragVel);
	}
}




};

activatePackage(ZoneEvents);
