
registerOutputEvent(fxDtsBrick, "setEventParameter", "int 0 99 0" TAB "int 1 4 1" TAB "string 200 156" TAB "bool", 0);

function fxDtsBrick::SetEventParameter(%brick, %eventIdx, %paramIdx, %paramIn, %append) {
	if(%append) %paramIn = %brick.eventOutputParameter[%eventIdx, %paramIdx] @ %paramIn;
	%paramV = verifyEventParameter(%brick, %eventIdx, %paramIdx, %paramIn);
	
	if($sep_paramValid) {
		%brick.eventOutputParameter[%eventIdx, %paramIdx] = %paramV;
	}
}

function verifyEventParameter(%brick, %eventIdx, %paramIdx, %paramIn) {
	$sep_paramValid = 0;
	
	%inputEventIdx = %brick.eventInputIdx[%eventIdx]; if(%inputEventIdx $= "") return;
	%targetIdx = %brick.eventTargetIdx[%eventIdx]; if(%targetIdx $= "") return;
	%targetClass = getWord(getField($InputEvent_TargetList["fxDtsBrick", %inputEventIdx], %targetIdx), 1); if(%targetClass $= "") return;
	%outputEventIdx = %brick.eventOutputIdx[%eventIdx]; if(%outputEventIdx $= "") return;
	
	%i = %paramIdx;
	%verifiedPar[%i] = "";
	%par[%i] = %paramIn;
	
	// Copied from serverCmdAddEvent
	
	%field = getField($OutputEvent_parameterList[%targetClass,%outputEventIdx], %i - 1.0); if(%field $= "") return;
	%type = getWord(%field, 0); if (%type $= "") return;
	if (%type $= "int")
	{
		%min = mFloor(getWord(%field, 1));
		%max = mFloor(getWord(%field, 2));
		%default = mFloor(getWord(%field, 3));
		%val = %par[%i];
		if (%val $= "")
		{
			%val = %default;
		}
		%verifiedPar[%i] = mClamp(%val, %min, %max);
	} else if (%type $= "intList") {
		%wordCount = getWordCount(%par[%i]);
		if (%par[%i] $= "ALL")
		{
			%verifiedPar[%i] = "ALL";
		}
		else
		{
			%verifiedPar[%i] = "";
			%w = 0;
			while(%w < %wordCount)
			{
				%word = atoi(getWord(%par[%i], %w));
				if (%w == 0.0)
				{
					%verifiedPar[%i] = %word;
				}
				else
				{
					%verifiedPar[%i] = %verifiedPar[%i] @ %word;
				}
				%w = %w + 1.0;
			}
		}
	} else if (%type $= "float") {
		%min = atof(getWord(%field, 1));
		%max = atof(getWord(%field, 2));
		%step = mAbs(getWord(%field, 3));
		%default = atof(getWord(%field, 4));
		%val = %par[%i];
		if (%val $= "") %val = %default;
		%val = mClampF(%val, %min, %max);
		%numSteps = mFloor((%val - %min) / %step);
		%val = %min + %numSteps * %step;
		%verifiedPar[%i] = %val;
	} else if (%type $= "bool") {
		if (%par[%i]) %verifiedPar[%i] = 1;
		else %verifiedPar[%i] = 0;
	} else if (%type $= "string") {
		%maxLength = mFloor(getWord(%field, 1));
		%width = mFloor(getWord(%field, 2));
		%par[%i] = strreplace(%par[%i], "<font:", "&A01");
		%par[%i] = strreplace(%par[%i], "<color:", "&A02");
		%par[%i] = strreplace(%par[%i], "<bitmap:", "&A03");
		%par[%i] = strreplace(%par[%i], "<shadow:", "&A04");
		%par[%i] = strreplace(%par[%i], "<shadowcolor:", "&A05");
		%par[%i] = strreplace(%par[%i], "<linkcolor:", "&A06");
		%par[%i] = strreplace(%par[%i], "<linkcolorHL:", "&A07");
		%par[%i] = strreplace(%par[%i], "<a:", "&A08");
		%par[%i] = strreplace(%par[%i], "</a>", "&A09");
		%par[%i] = strreplace(%par[%i], "<br>", "&A10");
		%par[%i] = StripMLControlChars(%par[%i]);
		%par[%i] = strreplace(%par[%i], "&A01", "<font:");
		%par[%i] = strreplace(%par[%i], "&A02", "<color:");
		%par[%i] = strreplace(%par[%i], "&A03", "<bitmap:");
		%par[%i] = strreplace(%par[%i], "&A04", "<shadow:");
		%par[%i] = strreplace(%par[%i], "&A05", "<shadowcolor:");
		%par[%i] = strreplace(%par[%i], "&A06", "<linkcolor:");
		%par[%i] = strreplace(%par[%i], "&A07", "<linkcolorHL:");
		%par[%i] = strreplace(%par[%i], "&A08", "<a:");
		%par[%i] = strreplace(%par[%i], "&A09", "</a>");
		%par[%i] = strreplace(%par[%i], "&A10", "<br>");
		%verifiedPar[%i] = getSubStr(%par[%i], 0, %maxLength);
		%verifiedPar[%i] = chatWhiteListFilter(%verifiedPar[%i]);
		%verifiedPar[%i] = strreplace(%verifiedPar[%i], ";", "");
	} else if (%type $= "datablock") {
		%dbClassName = getWord(%field, 1);
		if (isObject(%par[%i])){
			%newDB = %par[%i].getId();
		} else if (%par[%i] $= "NONE" || %par[%i] $= -1) {
			%newDB = -1.0;
		} else if (%dbClassName $= "FxLightData") {
			%newDB = "PlayerLight";
		} else if (%dbClassName $= "ItemData") {
			%newDB = "hammerItem";
		} else if (%dbClassName $= "ProjectileData") {
			if (isObject(gunProjectile)) {
				%newDB = "gunProjectile";
			} else {
				%newDB = "deathProjectile";
			}
		} else if (%dbClassName $= "ParticleEmitterData") {
			%newDB = "PlayerFoamEmitter";
		} else if (%dbClassName $= "Music") {
			%newDB = "musicData_After_School_Special";
		} else if (%dbClassName $= "Sound") {
			%newDB = "lightOnSound";
		} else if (%dbClassName $= "Vehicle") {
			%newDB = "JeepVehicle";
		} else if (%dbClassName $= "PlayerData") {
			%newDB = "PlayerStandardArmor";
		} else {
			%newDB = -1;
		}
		if (isObject(%newDB)) %newDB = %newDB.getId();
		else %newDB = -1;
		if (!isObject(%newDB)) %newDB = -1;
		if (%newDB != -1) {
			if (%dbClassName $= "Music") {
				if (%newDB.getClassName() !$= "AudioProfile") return;
				if (%newDB.uiName $= "") return;
			} else if (%dbClassName $= "Sound") {
				if (%newDB.getClassName() !$= "AudioProfile") return;
				if (%newDB.uiName !$= "") return;
				if (%newDB.getDescription().isLooping == 1.0) return;
				if (!%newDB.getDescription().is3D) return;
			} else if (%dbClassName $= "Vehicle") {
				%dbClass = %newDB.getClassName();
				if (%newDB.uiName $= "") return;
				if (
					%dbClass !$= "WheeledVehicleData" &&
					%dbClass !$= "HoverVehicleData" &&
					%dbClass !$= "FlyingVehicleData" &&
					(%dbClass !$= "PlayerData" && %newDB.rideAble)
				) return;
			} else if (%newDB.getClassName() !$= %dbClassName) {
				return;
			}
			if (%newDB.uiName $= "") return;
			%verifiedPar[%i] = %newDB;
		}
	} else if (%type $= "vector") {
		%x = atof(getWord(%par[%i], 0));
		%y = atof(getWord(%par[%i], 1));
		%z = atof(getWord(%par[%i], 2));
		%mag = atoi(getWord(%field, 1));
		if (%mag == 0.0) %mag = 200;
		%vec = %x @ %y @ %z;
		if (VectorLen(%vec) > %mag) {
			%vec = VectorNormalize(%vec);
			%vec = VectorScale(%vec, %mag);
			%x = atoi(getWord(%vec, 0));
			%y = atoi(getWord(%vec, 1));
			%z = atoi(getWord(%vec, 2));
		}
		%verifiedPar[%i] = %x @ %y @ %z;
	} else if (%type $= "list") {
		%val = mFloor(%par[%i]);
		%itemCount = (getWordCount(%field) - 1.0) / 2.0;
		%foundMatch = 0;
		%j = 0;
		while(%j < %itemCount) {
			%idx = %j * 2.0 + 1.0;
			%name = getWord(%field, %idx);
			%id = getWord(%field, %idx + 1.0);
			if (%val == %id) %foundMatch = 1;
			else %j = %j + 1.0;
		}
		if (!%foundMatch) return;
		%verifiedPar[%i] = %val;
	} else if (%type $= "paintColor") {
		%color = %par[%i];
		%verifiedPar[%i] = mClamp(%color, 0, $maxSprayColors);
	} else {
		error("ERROR: serverCmdAddEvent() - default type validation for type " @ %type @ "");
		%verifiedPar[%i] = strreplace(%par[%i], ";", "");
	}
	$sep_paramValid = 1;
	return %verifiedPar[%i];
}
