
// Brick_RedFill
// Redo 12878

//function rfb_reload(){
//	exec("./server.cs");
//	schedule(50, 0, transmitDatablocks);
//	schedule(100, 0, commandToAll, 'missionStartPhase3');
//}

package rfb_deleteBetas{
	
	function verifyBrickUiNames(){
		echo("RFB: Deleting betas");
		
		//%rfUiNames[]
		
		// find all alpha ui names
		for(%i=0; %i<getDatablockGroupSize(); %i++){
			%db = getDatablock(%i);
			if(%db.getClassName()$="fxDtsBrickData"){
				if(%db.isRedFill){
					%rfUiNames[%db.uiName] = 1;
					//echo("RF: Found RedFill " @ %db.getName());
				}
			}
		}
		
		//%betas[]
		%betaCount = 0;
		// find beta brickpack datablocks that have the same uiname as alpha bricks
		for(%i=0; %i<getDatablockGroupSize(); %i++){
			%db = getDatablock(%i);
			if(%db.getClassName()$="fxDtsBrickData"){
				if(%rfUiNames[%db.uiName] && !%db.isRedFill){
					%betas[%betaCount] = %db.getId();
					%betaCount++;
					echo("RF: Found inferior brick " @ %db.getName());
				}
			}
		}
		
		// delete the motherfuckers
		for(%i=0; %i<%betaCount; %i++){
			%db = %betas[%i];
			echo("    Deleting " @ %db.getName());
			%db.uiName = "";
			%db.brickFile = "";
			%db.iconName = "";
			%db.collisionShapeName = "";
			DatablockGroup.remove(%db);
		}
		
		echo("Done deleting");
		
		parent::verifyBrickUiNames();
	}
};
activatePackage(rfb_deleteBetas);

function rfb_sizeToName(%size){
	%lw = getWord(%size, 0) @ "x" @ getWord(%size, 1);
	%h = getWord(%size, 2);
	if(%h==1){
		return %lw @ "f";
	}else if(%h%3==0){
		if(%h==3){ return %lw; }
		else     { return %lw @ "x" @ %h/3; }
	}else{
		return %lw @ "x" @ %h @ "f";
	}
}

function rfb_generateBlbSize(%size){
	%name = rfb_sizeToName(%size);
	%fn = "Add-Ons/Brick_RedFill/bricks/" @ %name @ ".blb";
	if(!isFile(%fn)){
		%file = new FileObject();
		%s = %file.openForWrite(%fn);
		if(!%s){ echo("ERROR: Could not open file " @ %fn); return; }
		
		%file.writeLine(%size);
		%file.writeLine("BRICK");
		
		%file.close();
		%file.delete();
	}
}

function rfb_generateDatablockSize(%cat, %subcat, %size){
	%name = rfb_sizeToName(%size);
	%cmd = "datablock fxDtsBrickData(brickRf" @ %name @ "data){\n" @
		"brickFile = \"Add-Ons/Brick_RedFill/bricks/" @ %name @ ".blb\";\n" @
		"category = \"" @ %cat @ "\";\n" @
		"subCategory = \"" @ %subcat @ "\";\n" @
		"uiName = \"" @ %name @ "\";\n" @
		//"iconName = \"Add-Ons/Brick_RedFill/icons/" @ %name @ "\";\n" @
		"isRedFill = true;\n" @
	"};\n";
	eval(%cmd);
}

function rfb_generateSize(%cat, %subcat, %size){
	//rfb_generateBlbSize(%size); // generate blb if it doesnt exist - enable this if youre adding more bricks
	rfb_generateDatablockSize(%cat, %subcat, %size);
}

function rfb_generateList(%cat, %subcat, %depth, %height, %widthList){
	if(%widthList$="ALL"){
		%widthListNew = "";
		%listAll = "1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 24 32 48 64";
		for(%i=0; %i<getWordCount(%listAll); %i++){
			%width = getWord(%listAll, %i);
			if(%width>=%depth){
				%widthListNew = %widthListNew SPC %width;
			}
		}
		%widthList = trim(%widthListNew);
	}
	
	for(%i=0; %i<getWordCount(%widthList); %i++){
		%width = getWord(%widthList, %i);
		
		%size = %depth SPC %width SPC %height;
		rfb_generateSize(%cat, %subcat, %size);
	}
}

function rfb_generateAll(){
	// bricks
	rfb_generateList("Bricks",  "1x",  1, 3, "5 7 9 11 13 14 15 24 32 48 64");
	rfb_generateList("Bricks",  "2x",  2, 3, "5 7 9 11 12 13 14 15 16 24 32 48 64");
	rfb_generateList("Bricks",  "3x",  3, 3, "ALL");
	rfb_generateList("Bricks",  "4x",  4, 3, "5 7 9 11 13 14 15 24 32 48 64");
	rfb_generateList("Bricks",  "5x",  5, 3, "ALL");
	rfb_generateList("Bricks",  "6x",  6, 3, "ALL");
	rfb_generateList("Bricks",  "8x",  8, 3, "9 10 11 12 13 14 15 24 32 48 64");
	rfb_generateList("Bricks", "10x", 10, 3, "11 12 13 14 15 16 24 32 48 64");
	rfb_generateList("Bricks", "12x", 12, 3, "12 13 14 15 16 32 36 48 64");
	// plates
	rfb_generateList("Plates",  "1x",  1, 1, "5 7 9 11 13 14 15 24 32 48 64");
	rfb_generateList("Plates",  "2x",  2, 1, "5 7 9 11 12 13 14 15 16 24 32 48 64");
	rfb_generateList("Plates",  "3x",  3, 1, "ALL");
	rfb_generateList("Plates",  "4x",  4, 1, "5 7 9 11 13 14 15 24 32 48 64");
	rfb_generateList("Plates",  "5x",  5, 1, "ALL");
	rfb_generateList("Plates",  "6x",  6, 1, "7 9 11 13 14 15 32 48 64");
	rfb_generateList("Plates",  "8x",  8, 1, "9 10 11 12 13 14 15 24 32 48 64");
	rfb_generateList("Plates", "10x", 10, 1, "10 11 12 13 14 15 16 20 24 32 48 64");
	rfb_generateList("Plates", "12x", 12, 1, "12 13 14 15 16 24 32 36 48 64");
	// tall bricks
	rfb_generateList("Bricks", "2x Height", 1,  6, "ALL");
	rfb_generateList("Bricks", "2x Height", 2,  6, "ALL");
	rfb_generateList("Bricks", "3x Height", 1,  9, "ALL");
	rfb_generateList("Bricks", "3x Height", 2,  9, "3 5 7 8 9 10 11 12 13 14 15 16 24 32 48 64");
	rfb_generateList("Bricks", "4x Height", 1, 12, "ALL");
	rfb_generateList("Bricks", "4x Height", 2, 12, "ALL");
	rfb_generateList("Bricks", "5x Height", 1, 15, "5 7 8 9 10 11 13 14 15 16 24 32 48 64");
	rfb_generateList("Bricks", "5x Height", 2, 15, "5 7 8 9 10 11 13 14 15 16 24 32 48 64");
	rfb_generateList("Bricks", "6x Height", 1, 18, "ALL");
	rfb_generateList("Bricks", "6x Height", 2, 18, "ALL");
	// baseplates
	rfb_generateList("Baseplates", "Plain", 16, 1, "48 64");
	rfb_generateList("Baseplates", "Plain", 32, 1, "48 64");
	rfb_generateList("Baseplates", "Plain", 48, 1, "64");
	rfb_generateList("Baseplates", "Brick", 16, 3, "16 32 48 64");
	rfb_generateList("Baseplates", "Brick", 32, 3, "32 48 64");
	rfb_generateList("Baseplates", "Brick", 64, 3, "64");
	// half bricks
	rfb_generateList("Bricks", "1x Half",  1, 2, "ALL");
	rfb_generateList("Bricks", "2x Half",  2, 2, "ALL");
	rfb_generateList("Bricks", "3x Half",  3, 2, "ALL");
	rfb_generateList("Bricks", "4x Half",  4, 2, "ALL");
	rfb_generateList("Bricks", "5x Half",  5, 2, "ALL");
	rfb_generateList("Bricks", "6x Half",  6, 2, "ALL");
	rfb_generateList("Bricks", "8x Half",  8, 2, "ALL");
}
rfb_generateAll();
